# Aplikasi Absensi Sekolah (PHP + MySQLi + Bootstrap 5)

Instalasi cepat (XAMPP pada Windows):

1. Salin folder ini ke `C:\xampp\htdocs\absensi`.
2. Buat database MySQL (misal: `absensi_db`).
3. Impor skema tabel: jalankan `db_init.sql` di phpMyAdmin atau CLI.
4. Jalankan `setup_seed.php` sekali dari browser atau CLI untuk menambahkan akun admin/guru, kelas, dan siswa contoh.
   - Script akan meminta konfigurasi koneksi yang ada di `config.php`.
   - Default credentials yang dibuat oleh `setup_seed.php`:
     - Admin: `admin` / `admin123`
     - Guru: `guru1` / `guru123`
5. Buka `http://localhost/absensi/`.

Catatan keamanan:
- Semua query menggunakan prepared statements.
- CSRF token diterapkan pada form aksi.
- Untuk produksi, ubah konfigurasi DB dan atur HTTPS.

Apa yang ada di folder:
- `config.php` — koneksi DB dan inisialisasi session.
- `functions.php` — helper CSRF, auth, escape.
- `db_init.sql` — skema tabel.
- `setup_seed.php` — script seed (jalankan sekali).
- `index.php` — landing page dengan grafik absensi minggu ini.
- `login.php`, `logout.php` — autentikasi.
- `attendance.php` — halaman input absensi (guru/admin).
- `api/` — endpoint untuk chart dan menyimpan absensi.
- `admin/`, `teacher/` — dashboard dan manajemen sederhana.

Selanjutnya: buka `index.php` dan `login.php` untuk mencoba aplikasi.