<?php
require_once __DIR__ . '/../functions.php';
require_role(['admin']);
header('Content-Type: application/json');
$csrf = $_REQUEST['csrf'] ?? '';
if (!csrf_verify($csrf)) { echo json_encode(['ok'=>false,'error'=>'Invalid CSRF']); exit; }
$file = $_REQUEST['file'] ?? '';
$statements_per = isset($_REQUEST['statements']) ? (int)$_REQUEST['statements'] : 30;
$uploads = __DIR__ . '/../uploads';
$path = realpath($uploads . '/' . $file);
if (!$path || strpos($path, realpath($uploads)) !== 0) { echo json_encode(['ok'=>false,'error'=>'Invalid file']); exit; }
$fp = fopen($path, 'r');
if (!$fp) { echo json_encode(['ok'=>false,'error'=>'Cannot open file']); exit; }
$offset = isset($_REQUEST['offset']) ? (int)$_REQUEST['offset'] : 0;
if ($offset > 0) fseek($fp, $offset);
$processed = 0;
$done = false;
$db = get_db();
$buffer = '';
while ($processed < $statements_per && !feof($fp)) {
    $line = fgets($fp);
    if ($line === false) break;
    $trim = trim($line);
    // skip comments
    if ($trim === '' || strpos($trim, '--') === 0 || strpos($trim, '/*') === 0 || strpos($trim, '#') === 0) {
        $buffer .= $line;
        continue;
    }
    $buffer .= $line;
    // if line ends with semicolon -> statement ready
    if (preg_match('/;\s*$/', $line)) {
        $stmt = $buffer;
        $buffer = '';
        // execute statement
        if (!$db->multi_query($stmt)) {
            fclose($fp);
            echo json_encode(['ok'=>false,'error'=>'SQL error: '. $db->error, 'processed'=>$processed]);
            exit;
        }
        // consume possible result sets
        do { if ($res = $db->store_result()) { $res->free(); } } while ($db->more_results() && $db->next_result());
        $processed++;
    }
}
$offset_new = ftell($fp);
if (feof($fp)) $done = true;
fclose($fp);
echo json_encode(['ok'=>true,'processed'=>$processed,'offset'=>$offset_new,'done'=>$done]);
