<?php
require_once __DIR__ . '/../functions.php';
require_role(['admin']);
header('Content-Type: application/json');
$csrf = $_REQUEST['csrf'] ?? '';
if (!csrf_verify($csrf)) { echo json_encode(['ok'=>false,'error'=>'Invalid CSRF']); exit; }
$file = $_REQUEST['file'] ?? '';
$chunk = isset($_REQUEST['chunk']) ? max(1,(int)$_REQUEST['chunk']) : 50;
$uploads = __DIR__ . '/../uploads';
$path = realpath($uploads . '/' . $file);
if (!$path || strpos($path, realpath($uploads)) !== 0) { echo json_encode(['ok'=>false,'error'=>'Invalid file']); exit; }
if (!file_exists($path)) { echo json_encode(['ok'=>false,'error'=>'File not found']); exit; }
require_once __DIR__ . '/../vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\IOFactory;

// get total rows
try {
    $ss = IOFactory::load($path);
    $sheet = $ss->getActiveSheet();
    $totalRows = (int)$sheet->getHighestRow();
} catch (Exception $e) {
    echo json_encode(['ok'=>false,'error'=>'Failed to read spreadsheet: '.$e->getMessage()]); exit;
}
$offset = isset($_REQUEST['offset']) ? (int)$_REQUEST['offset'] : 2; // row number to start (1-based). default 2 skipping header
$endRow = min($totalRows, $offset + $chunk - 1);
$processed = 0;
$inserted = 0;
$db = get_db();
try {
    $db->begin_transaction();
    $stmtIns = $db->prepare('INSERT INTO students (name, class_id) VALUES (?, ?)');
    for ($r = $offset; $r <= $endRow; $r++) {
        $row = $sheet->rangeToArray('A'.$r.':B'.$r, NULL, true, false);
        $cells = $row[0];
        $name = trim((string)($cells[0] ?? ''));
        $classCell = trim((string)($cells[1] ?? ''));
        $processed++;
        if ($name === '') continue;
        $class_id = 0;
        if ($classCell !== '') {
            if (is_numeric($classCell)) $class_id = (int)$classCell;
            else {
                $stmtC = $db->prepare('SELECT id FROM classes WHERE name = ? LIMIT 1');
                $stmtC->bind_param('s', $classCell); $stmtC->execute(); $rc = $stmtC->get_result()->fetch_assoc();
                if ($rc) $class_id = (int)$rc['id'];
                $stmtC->close();
            }
        }
        $stmtIns->bind_param('si', $name, $class_id);
        $stmtIns->execute();
        $inserted++;
    }
    $db->commit();
    $stmtIns->close();
} catch (Exception $e) {
    $db->rollback();
    echo json_encode(['ok'=>false,'error'=>'DB error: '.$e->getMessage()]); exit;
}
$done = ($endRow >= $totalRows);
$newOffset = $endRow + 1;
echo json_encode(['ok'=>true,'processed'=>$processed,'inserted'=>$inserted,'offset'=>$newOffset,'done'=>$done,'totalRows'=>$totalRows]);
