<?php
require_once __DIR__ . '/../functions.php';
require_role(['admin']);
header('Content-Type: application/json');
if ($_SERVER['REQUEST_METHOD'] !== 'POST') { echo json_encode(['ok'=>false,'error'=>'Method not allowed']); exit; }
if (!csrf_verify($_POST['csrf'] ?? '')) { echo json_encode(['ok'=>false,'error'=>'Invalid CSRF']); exit; }
if (empty($_FILES['sql_file']) || $_FILES['sql_file']['error'] !== UPLOAD_ERR_OK) { echo json_encode(['ok'=>false,'error'=>'No file or upload error']); exit; }
$uploads = __DIR__ . '/../uploads';
if (!is_dir($uploads)) mkdir($uploads, 0755, true);
$fn = basename($_FILES['sql_file']['name']);
$uniq = time() . '_' . bin2hex(random_bytes(6));
$dest = $uploads . '/' . $uniq . '_' . preg_replace('/[^a-zA-Z0-9._-]/','_', $fn);
if (!move_uploaded_file($_FILES['sql_file']['tmp_name'], $dest)) { echo json_encode(['ok'=>false,'error'=>'Failed to move uploaded file']); exit; }
$size = filesize($dest);
echo json_encode(['ok'=>true,'file'=>basename($dest),'size'=>$size]);
