<?php
require_once __DIR__ . '/../functions.php';
require_role(['admin']);
$db = get_db();

// delete
// handle delete via POST (safer) or GET for backward compatibility
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete'])) {
    if (!csrf_verify($_POST['csrf'] ?? '')) {
        http_response_code(400);
        echo 'Invalid CSRF';
        exit;
    }
    $id = (int)$_POST['delete'];
    $stmt = $db->prepare("DELETE FROM users WHERE id = ? AND role != 'admin'");
    $stmt->bind_param('i', $id);
    $stmt->execute();
    header('Location: users.php?success=deleted');
    exit;
} elseif (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $stmt = $db->prepare("DELETE FROM users WHERE id = ? AND role != 'admin'");
    $stmt->bind_param('i', $id);
    $stmt->execute();
    header('Location: users.php?success=deleted');
    exit;
}
// load edit
$editing = null;
if (isset($_GET['edit'])) {
    $eid = (int)$_GET['edit'];
    $stmt = $db->prepare('SELECT id, username, name, role FROM users WHERE id = ? LIMIT 1');
    $stmt->bind_param('i', $eid);
    $stmt->execute();
    $editing = $stmt->get_result()->fetch_assoc();
}

// create or update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!csrf_verify($_POST['csrf'] ?? '')) {
        $err = 'Invalid CSRF';
    } else {
        $username = trim($_POST['username'] ?? '');
        $name = trim($_POST['name'] ?? '');
        $role = $_POST['role'] ?? 'guru';
        if ($username === '' || $name === '') {
            $err = 'Username and name are required';
        } else {
            // uniqueness check
            if (!empty($_POST['edit_id'])) {
                $edit_id = (int)$_POST['edit_id'];
                $stmt = $db->prepare("SELECT id FROM users WHERE username = ? AND id != ? LIMIT 1");
                $stmt->bind_param('si', $username, $edit_id);
                $stmt->execute();
                if ($stmt->get_result()->fetch_assoc()) {
                    $err = 'Username already used';
                } else {
                    if (!empty($_POST['password'])) {
                        $pass = password_hash($_POST['password'], PASSWORD_DEFAULT);
                        $stmt = $db->prepare("UPDATE users SET username=?, password=?, name=?, role=? WHERE id = ?");
                        $stmt->bind_param('ssssi', $username, $pass, $name, $role, $edit_id);
                    } else {
                        $stmt = $db->prepare("UPDATE users SET username=?, name=?, role=? WHERE id = ?");
                        $stmt->bind_param('sssi', $username, $name, $role, $edit_id);
                    }
                    $stmt->execute();
                    header('Location: users.php?success=updated');
                    exit;
                }
            } else {
                // new user
                $stmt = $db->prepare("SELECT id FROM users WHERE username = ? LIMIT 1");
                $stmt->bind_param('s', $username);
                $stmt->execute();
                if ($stmt->get_result()->fetch_assoc()) {
                    $err = 'Username already used';
                } else {
                    $pass = password_hash($_POST['password'], PASSWORD_DEFAULT);
                    $stmt = $db->prepare("INSERT INTO users (username, password, name, role) VALUES (?, ?, ?, ?)");
                    $stmt->bind_param('ssss', $username, $pass, $name, $role);
                    $stmt->execute();
                    header('Location: users.php?success=created');
                    exit;
                }
            }
        }
    }
}

$users = $db->query("SELECT id, username, name, role FROM users ORDER BY id ASC")->fetch_all(MYSQLI_ASSOC);
?>
<?php require_once __DIR__ . '/_header.php'; ?>
<h4>Manajemen Pengguna</h4>
<a href="dashboard.php" class="btn btn-sm btn-secondary mb-3">Kembali</a>
<div class="card mb-3 p-3">
    <?php if (!empty($err)): ?><div class="alert alert-danger"><?= h($err) ?></div><?php endif; ?>
    <form method="post" class="row g-2">
        <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
        <?php if ($editing): ?>
            <input type="hidden" name="edit_id" value="<?= h($editing['id']) ?>">
        <?php endif; ?>
        <div class="col-md-3"><input name="username" class="form-control" placeholder="username" required value="<?= h($editing['username'] ?? '') ?>"></div>
        <div class="col-md-3"><input name="name" class="form-control" placeholder="Nama" required value="<?= h($editing['name'] ?? '') ?>"></div>
        <div class="col-md-2"><input name="password" class="form-control" placeholder="password" <?= $editing ? '' : 'required' ?>></div>
        <div class="col-md-2">
            <select name="role" class="form-select">
                <option value="guru" <?= isset($editing) && $editing['role'] == 'guru' ? 'selected' : '' ?>>Guru</option>
                <option value="admin" <?= isset($editing) && $editing['role'] == 'admin' ? 'selected' : '' ?>>Admin</option>
            </select>
        </div>
        <div class="col-md-2"><button class="btn btn-primary"><?= $editing ? 'Simpan Perubahan' : 'Tambah' ?></button>
            <?php if ($editing): ?> <a href="users.php" class="btn btn-outline-secondary ms-2">Batal</a><?php endif; ?>
        </div>
    </form>
</div>
<table class="table table-striped datatable">
    <thead>
        <tr>
            <th>ID</th>
            <th>Username</th>
            <th>Nama</th>
            <th>Role</th>
            <th>Aksi</th>
        </tr>
    </thead>
    <tbody>
        <?php $n = 1;
        foreach ($users as $u): ?>
            <tr>
                <td><?= $n++ ?></td>
                <td><?= h($u['username']) ?></td>
                <td><?= h($u['name']) ?></td>
                <td><?= h($u['role']) ?></td>
                <td>
                    <?php if ($u['role'] !== 'admin'): ?>
                        <a href="users.php?edit=<?= h($u['id']) ?>" class="btn btn-sm btn-outline-primary">Edit</a>
                        <a href="#" data-id="<?= h($u['id']) ?>" class="btn btn-sm btn-danger btn-delete" data-msg="Hapus pengguna <?= h($u['username']) ?>?">Hapus</a>
                    <?php elseif ($u['role'] == 'admin'): ?>
                        <a href="users.php?edit=<?= h($u['id']) ?>" class="btn btn-sm btn-outline-primary">Edit</a>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>
<?php if (!empty($_GET['success'])):
    $s = $_GET['success'];
    $map = ['deleted' => 'Pengguna dihapus', 'updated' => 'Perubahan tersimpan', 'created' => 'Pengguna ditambahkan'];
    $msg = isset($map[$s]) ? $map[$s] : 'Sukses';
?>
    <script>
        (function() {
            var msg = <?= json_encode($msg) ?>;
            if (typeof Swal === 'undefined') {
                // fallback
                console && console.log && console.log('Toast: ' + msg);
                alert(msg);
            } else {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'success',
                    title: msg,
                    showConfirmButton: false,
                    timer: 2500
                });
            }
        })();
    </script>
<?php endif; ?>

<!-- Page-specific delete handler using SweetAlert2 to override global behavior -->
<script>
    (function() {
        document.body.addEventListener('click', function(e) {
            var el = e.target.closest && e.target.closest('.btn-delete');
            if (!el) return;
            // prevent any other delete handlers from running
            e.stopImmediatePropagation();
            e.preventDefault();
            var id = el.dataset.id;
            var msg = el.dataset.msg || 'Yakin ingin menghapus item ini?';
            // ensure Swal exists
            if (typeof Swal === 'undefined') {
                if (!confirm(msg)) return;
                var f = document.createElement('form');
                f.method = 'post';
                f.style.display = 'none';
                document.body.appendChild(f);
                var i = document.createElement('input');
                i.type = 'hidden';
                i.name = 'delete';
                i.value = id;
                f.appendChild(i);
                var c = document.createElement('input');
                c.type = 'hidden';
                c.name = 'csrf';
                c.value = document.querySelector('input[name="csrf"]') ? document.querySelector('input[name="csrf"]').value : '';
                f.appendChild(c);
                f.action = el.dataset.action || window.location.pathname;
                f.submit();
                return;
            }
            Swal.fire({
                title: 'Hapus?',
                text: msg,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Ya, hapus',
                cancelButtonText: 'Batal',
                confirmButtonColor: '#d33'
            }).then(function(res) {
                if (!res.isConfirmed) return;
                // show loading
                Swal.fire({
                    title: 'Menghapus...',
                    allowOutsideClick: false,
                    didOpen: function() {
                        Swal.showLoading();
                    }
                });
                var form = document.createElement('form');
                form.method = 'post';
                form.style.display = 'none';
                document.body.appendChild(form);
                var del = document.createElement('input');
                del.type = 'hidden';
                del.name = 'delete';
                del.value = id;
                form.appendChild(del);
                var csrf = document.createElement('input');
                csrf.type = 'hidden';
                csrf.name = 'csrf';
                csrf.value = document.querySelector('input[name="csrf"]') ? document.querySelector('input[name="csrf"]').value : '';
                form.appendChild(csrf);
                form.action = el.dataset.action || window.location.pathname;
                // submit; server redirects back with ?success=deleted
                form.submit();
            });
        }, true);
    })();
</script>

<?php require_once __DIR__ . '/_footer.php'; ?>