<?php
require_once __DIR__ . '/../functions.php';
$db = get_db();

$labels = [];
$hadir = [];
$tidak = [];
for ($d = 6; $d >= 0; $d--) {
    $date = date('Y-m-d', strtotime("-{$d} days"));
    $labels[] = date('D, j M', strtotime($date));
    // hadir count
    $stmt = $db->prepare("SELECT COUNT(*) as cnt FROM attendance WHERE date = ? AND status = 'Hadir'");
    $stmt->bind_param('s', $date); $stmt->execute(); $r = $stmt->get_result()->fetch_assoc();
    $hadir[] = (int)$r['cnt'];
    // tidak hadir
    $stmt = $db->prepare("SELECT COUNT(*) as cnt FROM attendance WHERE date = ? AND status != 'Hadir'");
    $stmt->bind_param('s', $date); $stmt->execute(); $r = $stmt->get_result()->fetch_assoc();
    $tidak[] = (int)$r['cnt'];
}

header('Content-Type: application/json');
echo json_encode(['labels' => $labels, 'hadir' => $hadir, 'tidak' => $tidak]);
