<?php
require_once __DIR__ . '/functions.php';
$user = current_user();
?><!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Absensi Sekolah</title>
  <link href="assets/vendor/bootstrap.min.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
  <script src="assets/vendor/chart.min.js"></script>
</head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
  <div class="container">
    <a class="navbar-brand" href="/absensi/">Absensi</a>
    <div class="d-flex align-items-center">
      <?php if (!is_logged_in()): ?>
        <a class="btn btn-sm btn-outline-secondary me-2" href="login.php">Login Admin</a>
      <?php else: $u = current_user(); if ($u['role']==='admin'): ?>
        <a class="btn btn-sm btn-outline-primary me-2" href="admin/dashboard.php">Dashboard</a>
        <a class="btn btn-sm btn-outline-secondary me-2" href="admin/users.php">Pengguna</a>
        <a class="btn btn-sm btn-outline-secondary me-2" href="admin/classes.php">Kelas</a>
        <a class="btn btn-sm btn-outline-secondary me-2" href="admin/students.php">Siswa</a>
        <a class="btn btn-sm btn-outline-secondary me-2" href="admin/reports.php">Rekap</a>
      <?php else: ?>
        <a class="btn btn-sm btn-outline-primary me-2" href="teacher/dashboard.php">Dashboard</a>
      <?php endif; ?>
        <a class="btn btn-sm btn-outline-danger btn-logout" href="logout.php">Logout</a>
      <?php endif; ?>
    </div>
  </div>
</nav>

<main class="container py-4">
  <div class="row mb-4">
    <div class="col-12">
      <div class="hero p-4 card-ghost">
        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between">
          <div>
            <h1 class="mb-1" style="color:#7b1fa2;">Absensi Sekolah</h1>
            <p class="small-muted mb-0">Ringkasan kehadiran minggu ini — data diambil langsung dari sistem absensi.</p>
          </div>
          <div class="text-end mt-3 mt-md-0">
            <?php if (is_logged_in()): ?><small class="small-muted">Halo, <?=h($user['name'] ?? '')?></small><?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="row">
    <div class="col-12">
      <div class="card shadow-sm">
        <div class="card-body">
          <h5 class="card-title">Grafik Absensi Minggu Ini</h5>
          <div style="height:260px;">
            <canvas id="attendanceChart" height="120"></canvas>
          </div>
        </div>
      </div>
    </div>
  </div>
</main>

<script src="assets/vendor/bootstrap.bundle.min.js"></script>
<script>
async function loadChart() {
  const res = await fetch('api/chart.php');
  const data = await res.json();
  const ctx = document.getElementById('attendanceChart').getContext('2d');
  new Chart(ctx, {
    type: 'bar',
    data: {
      labels: data.labels,
      datasets: [
        { label: 'Hadir', backgroundColor: '#f48fb1', data: data.hadir },
        { label: 'Tidak Hadir (Sakit/Izin/Alpha)', backgroundColor: '#f8bbd0', data: data.tidak }
      ]
    },
    options: { responsive: true, maintainAspectRatio: false }
  });
}
loadChart();
</script>
<script src="assets/vendor/sweetalert2.min.js"></script>
<script src="assets/js/admin.js"></script>
</body>
</html>