<?php
require_once __DIR__ . '/../functions.php';
require_role(['admin']);
$db = get_db();

// handle delete via POST (safer) or GET for backward compatibility
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete'])) {
    if (!csrf_verify($_POST['csrf'] ?? '')) { http_response_code(400); echo 'Invalid CSRF'; exit; }
    $id = (int)$_POST['delete'];
    $stmt = $db->prepare('DELETE FROM classes WHERE id=?');
    $stmt->bind_param('i', $id);
    $stmt->execute();
    header('Location: classes.php');
    exit;
} elseif (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $stmt = $db->prepare('DELETE FROM classes WHERE id=?');
    $stmt->bind_param('i', $id);
    $stmt->execute();
    header('Location: classes.php');
    exit;
}

// load edit
$editing = null;
if (isset($_GET['edit'])) {
    $eid = (int)$_GET['edit'];
    $stmt = $db->prepare('SELECT id, name, teacher_id FROM classes WHERE id = ? LIMIT 1');
    $stmt->bind_param('i', $eid);
    $stmt->execute();
    $editing = $stmt->get_result()->fetch_assoc();
}

// create or update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!csrf_verify($_POST['csrf'] ?? '')) {
        $err = 'Invalid CSRF';
    } else {
        $name = trim($_POST['name'] ?? '');
        $teacher_id = !empty($_POST['teacher_id']) ? (int)$_POST['teacher_id'] : null;
        if ($name === '') {
            $err = 'Nama kelas diperlukan';
        } else {
            if (!empty($_POST['edit_id'])) {
                $edit_id = (int)$_POST['edit_id'];
                $stmt = $db->prepare('UPDATE classes SET name=?, teacher_id=? WHERE id=?');
                $stmt->bind_param('sii', $name, $teacher_id, $edit_id);
                $stmt->execute();
                header('Location: classes.php');
                exit;
            } else {
                $stmt = $db->prepare('INSERT INTO classes (name, teacher_id) VALUES (?, ?)');
                $stmt->bind_param('si', $name, $teacher_id);
                $stmt->execute();
                header('Location: classes.php');
                exit;
            }
        }
    }
}

$teachers = $db->query("SELECT id, name FROM users WHERE role='guru'")->fetch_all(MYSQLI_ASSOC);
$classes = $db->query('SELECT c.id, c.name, u.name as teacher FROM classes c LEFT JOIN users u ON u.id=c.teacher_id ORDER BY c.name')->fetch_all(MYSQLI_ASSOC);
?>
<?php require_once __DIR__ . '/_header.php'; ?>
<h4>Manajemen Kelas</h4>
<?php if (!empty($err)): ?><div class="alert alert-danger"><?= h($err) ?></div><?php endif; ?>
<form method="post" class="row g-2 mb-3">
    <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
    <?php if ($editing): ?> <input type="hidden" name="edit_id" value="<?= h($editing['id']) ?>"> <?php endif; ?>
    <div class="col-md-4"><input name="name" class="form-control" placeholder="Nama kelas" required value="<?= h($editing['name'] ?? '') ?>"></div>
    <div class="col-md-4">
        <select name="teacher_id" class="form-select">
            <option value="">-- Pilih Guru --</option>
            <?php foreach ($teachers as $t): ?><option value="<?= h($t['id']) ?>" <?= isset($editing) && $editing['teacher_id'] == $t['id'] ? 'selected' : '' ?>><?= h($t['name']) ?></option><?php endforeach; ?>
        </select>
    </div>
    <div class="col-md-4">
        <button class="btn btn-primary"><?= $editing ? 'Simpan Perubahan' : 'Tambah Kelas' ?></button>
        <?php if ($editing): ?> <a href="classes.php" class="btn btn-outline-secondary ms-2">Batal</a> <?php endif; ?>
    </div>
</form>

<table class="table table-striped datatable">
    <thead>
        <tr>
            <th>ID</th>
            <th>Nama</th>
            <th>Guru</th>
            <th>Aksi</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($classes as $c): ?>
            <tr>
                <td><?= h($c['id']) ?></td>
                <td><?= h($c['name']) ?></td>
                <td><?= h($c['teacher']) ?></td>
                <td>
                    <a href="classes.php?edit=<?= h($c['id']) ?>" class="btn btn-sm btn-outline-primary">Edit</a>
                    <a href="#" data-id="<?= h($c['id']) ?>" class="btn btn-sm btn-danger btn-delete" data-msg="Hapus kelas <?=h($c['name'])?>?">Hapus</a>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>
<?php require_once __DIR__ . '/_footer.php'; ?>