<?php
require_once __DIR__ . '/../functions.php';
require_role(['admin']);
$db = get_db();
// summary counts
$totStudents = $db->query('SELECT COUNT(*) as c FROM students')->fetch_assoc()['c'];
$totClasses = $db->query('SELECT COUNT(*) as c FROM classes')->fetch_assoc()['c'];
$totTeachers = $db->query("SELECT COUNT(*) as c FROM users WHERE role='guru'")->fetch_assoc()['c'];

?>
<!doctype html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <title>Admin Dashboard</title>
    <?php
    require_once __DIR__ . '/../functions.php';
    require_role(['admin']);
    $db = get_db();
    // summary counts
    $totStudents = $db->query('SELECT COUNT(*) as c FROM students')->fetch_assoc()['c'];
    $totClasses = $db->query('SELECT COUNT(*) as c FROM classes')->fetch_assoc()['c'];
    $totTeachers = $db->query("SELECT COUNT(*) as c FROM users WHERE role='guru'")->fetch_assoc()['c'];

    require_once __DIR__ . '/_header.php';

    ?>
    <h3>Dashboard Admin</h3>
    <div class="row mb-3">
        <div class="col-md-4">
            <div class="card dashboard-card p-3">Total Siswa: <strong><?= h($totStudents) ?></strong></div>
        </div>
        <div class="col-md-4">
            <div class="card dashboard-card p-3">Total Kelas: <strong><?= h($totClasses) ?></strong></div>
        </div>
        <div class="col-md-4">
            <div class="card dashboard-card p-3">Total Guru: <strong><?= h($totTeachers) ?></strong></div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card dashboard-card mb-3">
                <div class="card-body">
                    <h5 class="card-title">Rekap Bulanan (Tahun <?= h(date('Y')) ?>)</h5>
                    <div style="height:260px;"><canvas id="chartMonthly"></canvas></div>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card dashboard-card mb-3">
                <div class="card-body">
                    <h5 class="card-title">Rekap Harian (30 hari terakhir)</h5>
                    <div style="height:260px;"><canvas id="chartDaily"></canvas></div>
                </div>
            </div>
        </div>
    </div>

    <script>
        async function loadMonthly() {
            const res = await fetch('../api/chart_monthly.php');
            const d = await res.json();
            const ctx = document.getElementById('chartMonthly').getContext('2d');
            new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: d.labels,
                    datasets: [{
                        label: 'Hadir',
                        backgroundColor: '#f48fb1',
                        data: d.hadir
                    }, {
                        label: 'Tidak',
                        backgroundColor: '#f8bbd0',
                        data: d.tidak
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false
                }
            });
        }
        async function loadDaily() {
            const res = await fetch('../api/chart_daily.php?days=30');
            const d = await res.json();
            const ctx = document.getElementById('chartDaily').getContext('2d');
            new Chart(ctx, {
                type: 'line',
                data: {
                    labels: d.labels,
                    datasets: [{
                        label: 'Hadir',
                        borderColor: '#f48fb1',
                        backgroundColor: 'rgba(244,143,177,0.12)',
                        data: d.hadir,
                        fill: true
                    }, {
                        label: 'Tidak',
                        borderColor: '#f8bbd0',
                        backgroundColor: 'rgba(248,187,208,0.08)',
                        data: d.tidak,
                        fill: true
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false
                }
            });
        }
        loadMonthly();
        loadDaily();
    </script>

    <?php require_once __DIR__ . '/_footer.php'; ?>