<?php
require_once __DIR__ . '/../functions.php';
require_login();
$db = get_db();
$user = current_user();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); echo 'Method not allowed'; exit;
}
if (!csrf_verify($_POST['csrf'] ?? '')) { http_response_code(400); echo 'Invalid CSRF'; exit; }

$class_id = (int)($_POST['class_id'] ?? 0);
$date = $_POST['date'] ?? date('Y-m-d');
$statuses = $_POST['status'] ?? [];

// verify class exists
$stmt = $db->prepare("SELECT id FROM classes WHERE id = ? LIMIT 1");
$stmt->bind_param('i', $class_id); $stmt->execute(); $r = $stmt->get_result();
if (!$r->fetch_assoc()) { http_response_code(400); echo 'Invalid class'; exit; }

$db->begin_transaction();
try {
    foreach ($statuses as $student_id => $status) {
        $student_id = (int)$student_id;
        // upsert: delete existing for that student/date then insert
        $stmt = $db->prepare("DELETE FROM attendance WHERE student_id = ? AND date = ?");
        $stmt->bind_param('is', $student_id, $date); $stmt->execute();
        $stmt = $db->prepare("INSERT INTO attendance (class_id, student_id, date, status) VALUES (?, ?, ?, ?)");
        $stmt->bind_param('iiss', $class_id, $student_id, $date, $status); $stmt->execute();
    }
    $db->commit();
    header('Location: ../attendance.php?class=' . $class_id . '&date=' . $date);
    exit;
} catch (Exception $e) {
    $db->rollback();
    http_response_code(500); echo 'Save failed';
}
