<?php
require_once __DIR__ . '/../functions.php';
$db = get_db();

// Optional filter: teacher_id (for teacher dashboard) or class_id
$teacher_id = isset($_GET['teacher_id']) ? (int)$_GET['teacher_id'] : null;
$class_id = isset($_GET['class_id']) ? (int)$_GET['class_id'] : null;
$year = isset($_GET['year']) ? (int)$_GET['year'] : (int)date('Y');

$labels = [];
$hadir = array_fill(0, 12, 0);
$tidak = array_fill(0, 12, 0);
for ($m=1; $m<=12; $m++) $labels[] = date('M', strtotime("{$year}-".str_pad($m,2,'0',STR_PAD_LEFT)."-01"));

// build query
$sql = "SELECT MONTH(a.date) as m, SUM(a.status='Hadir') as hadir, SUM(a.status!='Hadir') as tidak
        FROM attendance a
        JOIN classes c ON c.id = a.class_id
        WHERE YEAR(a.date) = ?";
$params = [];
$types = 'i';
$params[] = $year;
if ($teacher_id) { $sql .= " AND c.teacher_id = ?"; $types .= 'i'; $params[] = $teacher_id; }
if ($class_id)   { $sql .= " AND a.class_id = ?"; $types .= 'i'; $params[] = $class_id; }
$sql .= " GROUP BY MONTH(a.date)";

$stmt = $db->prepare($sql);
if ($types) $stmt->bind_param($types, ...$params);
$stmt->execute();
$res = $stmt->get_result();
while ($r = $res->fetch_assoc()) {
    $idx = (int)$r['m'] - 1;
    $hadir[$idx] = (int)$r['hadir'];
    $tidak[$idx] = (int)$r['tidak'];
}

header('Content-Type: application/json');
echo json_encode(['labels'=>$labels, 'hadir'=>$hadir, 'tidak'=>$tidak, 'year'=>$year]);

?>
