// admin.js - initialize DataTables and logout confirmation
document.addEventListener('DOMContentLoaded', function(){
  // quick diagnostics to help debug missing SweetAlert2 / handler issues
  try {
    // ensure common global name exists (some bundles export Sweetalert2 instead of Swal)
    if (!window.Swal && window.Sweetalert2) window.Swal = window.Sweetalert2;
    console.debug('admin.js loaded, SweetAlert available:', !!window.Swal);
  } catch (e) { console.error('admin.js init error', e); }
  // initialize DataTables if jQuery + DataTables loaded
  if (window.jQuery && jQuery().DataTable) {
    jQuery('.datatable').each(function(){
      try { jQuery(this).DataTable({ responsive: true, pageLength: 25 }); } catch(e) {}
    });
  }

  // SweetAlert2 logout confirmation (Indonesian)
  function handleLogoutClick(e){
    var el = e.target.closest('.btn-logout');
    if (!el) return;
    e.preventDefault();
    var href = el.getAttribute('href') || el.dataset.href || './logout.php';
    console.debug('Logout clicked, href=', href);
    if (window.Swal) {
      Swal.fire({
        title: 'Keluar?',
        text: 'Anda akan keluar dari sesi. Lanjutkan?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Ya, keluar',
        cancelButtonText: 'Batal',
        confirmButtonColor: '#d33'
      }).then(function(res){ if (res.isConfirmed) { window.location = href; } });
    } else {
      if (confirm('Yakin ingin keluar?')) window.location = href;
    }
  }

  // Delete confirmation (uses a global hidden form to POST delete with CSRF)
  function handleDeleteClick(e){
    var el = e.target.closest('.btn-delete');
    if (!el) return;
    e.preventDefault();
    var id = el.dataset.id;
    var msg = el.dataset.msg || 'Yakin ingin menghapus item ini?';
    if (window.Swal) {
      Swal.fire({
        title: 'Hapus?',
        text: msg,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Ya, hapus',
        cancelButtonText: 'Batal',
        confirmButtonColor: '#d33'
      }).then(function(res){ if (res.isConfirmed) {
          var form = document.getElementById('global-delete-form');
          if (!form) {
            form = document.createElement('form'); form.method='post'; form.style.display='none'; document.body.appendChild(form);
            var csrf = document.createElement('input'); csrf.type='hidden'; csrf.name='csrf'; csrf.value=''; csrf.id='global-delete-csrf'; form.appendChild(csrf);
            var del = document.createElement('input'); del.type='hidden'; del.name='delete'; del.id='global-delete-id'; form.appendChild(del);
          }
          // set values
          var delInput = document.getElementById('global-delete-id'); delInput.value = id;
          var csrfInput = document.getElementById('global-delete-csrf');
          // try to read csrf token from a meta tag or existing hidden inputs
          var token = document.querySelector('input[name="csrf"]') ? document.querySelector('input[name="csrf"]').value : (document.querySelector('meta[name="csrf-token"]') ? document.querySelector('meta[name="csrf-token"]').getAttribute('content') : '');
          csrfInput.value = token;
          form.action = el.dataset.action || window.location.pathname;
          form.submit();
      }});
    } else {
      if (confirm(msg)) {
        var f = document.createElement('form'); f.method='post'; f.style.display='none'; document.body.appendChild(f);
        var i = document.createElement('input'); i.type='hidden'; i.name='delete'; i.value=id; f.appendChild(i);
        var c = document.createElement('input'); c.type='hidden'; c.name='csrf'; c.value=document.querySelector('input[name="csrf"]') ? document.querySelector('input[name="csrf"]').value : ''; f.appendChild(c);
        f.action = el.dataset.action || window.location.pathname; f.submit();
      }
    }
  }

  document.body.addEventListener('click', function(e){ if (e.target.closest('.btn-logout')) handleLogoutClick(e); if (e.target.closest('.btn-delete')) handleDeleteClick(e); });
});
