<?php
// generate_students_template.php
// Usage: php scripts/generate_students_template.php

require __DIR__ . '/../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Font;

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Header
$sheet->setCellValue('A1', 'Nama');
$sheet->setCellValue('B1', 'Kelas');
$sheet->getStyle('A1:B1')->getFont()->setBold(true);

// Example row
$sheet->setCellValue('A2', 'Budi Contoh');
$sheet->setCellValue('B2', 'X IPA 1');

$dir = __DIR__ . '/../assets/templates';
if (!is_dir($dir)) {
    mkdir($dir, 0755, true);
}
$filename = $dir . '/students_template.xlsx';

$writer = new Xlsx($spreadsheet);
try {
    $writer->save($filename);
    echo "Template saved to: $filename\n";
} catch (Exception $e) {
    fwrite(STDERR, 'Error: ' . $e->getMessage() . "\n");
    exit(1);
}
