<?php
require_once __DIR__ . '/../functions.php';
require_role(['guru']);
$db = get_db();
$user = current_user();
// list all classes (allow guru to see all classes)
$stmt = $db->prepare("SELECT id, name FROM classes ORDER BY name");
$stmt->execute();
$classes = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

?>
<!doctype html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <link href="../assets/vendor/bootstrap.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
    <title>Dashboard Guru</title>
</head>

<body>
    <nav class="navbar navbar-light bg-white shadow-sm">
        <div class="container">
            <a class="navbar-brand" href="/absensi/">Absensi Siswa</a>
            <div>
                <a href="../attendance.php" class="btn btn-sm btn-success me-2">Absensi</a>
                <a href="../logout.php" class="btn btn-sm btn-danger btn-logout">Logout</a>
            </div>
        </div>
    </nav>
    <main class="container py-4">
        <h3>Dashboard Guru</h3>
        <p>Halo, <?= h($user['name']) ?>. Daftar kelas anda:</p>
        <ul>
            <?php foreach ($classes as $c): ?><li><?= h($c['name']) ?></li><?php endforeach; ?>
        </ul>

        <div class="row">
            <div class="col-md-6">
                <div class="card mb-3">
                    <div class="card-body">
                        <h5 class="card-title">Rekap Bulanan (kelas yang diampu)</h5>
                        <div style="height:220px;"><canvas id="chartMonthlyTeacher"></canvas></div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card mb-3">
                    <div class="card-body">
                        <h5 class="card-title">Rekap Harian (30 hari)</h5>
                        <div style="height:220px;"><canvas id="chartDailyTeacher"></canvas></div>
                    </div>
                </div>
            </div>
        </div>

        <script src="../assets/vendor/chart.min.js"></script>
        <script src="../assets/js/admin.js"></script>
        <script src="../assets/vendor/jquery.min.js"></script>
        <script src="../assets/vendor/jquery.dataTables.min.js"></script>
        <script src="../assets/vendor/dataTables.responsive.min.js"></script>
        <script src="../assets/vendor/bootstrap.bundle.min.js"></script>
        <script src="../assets/vendor/sweetalert2.min.js"></script>
        <script src="../assets/js/admin.js"></script>
           <!-- SweetAlert2 CSS (local preferred, CDN fallback) -->
           <?php if (file_exists(__DIR__ . '/../assets/vendor/sweetalert2.min.css')): ?>
               <link rel="stylesheet" href="../assets/vendor/sweetalert2.min.css">
           <?php else: ?>
               <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
           <?php endif; ?>
        <script>
            async function loadTeacherCharts() {
                // pass teacher_id to API to filter
                const tid = <?= (int)$user['id'] ?>;
                const mres = await fetch('../api/chart_monthly.php?teacher_id=' + tid);
                const md = await mres.json();
                new Chart(document.getElementById('chartMonthlyTeacher').getContext('2d'), {
                    type: 'bar',
                    data: {
                        labels: md.labels,
                        datasets: [{
                            label: 'Hadir',
                            backgroundColor: '#f48fb1',
                            data: md.hadir
                        }, {
                            label: 'Tidak',
                            backgroundColor: '#f8bbd0',
                            data: md.tidak
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false
                    }
                });

                const dres = await fetch('../api/chart_daily.php?teacher_id=' + tid + '&days=30');
                const dd = await dres.json();
                new Chart(document.getElementById('chartDailyTeacher').getContext('2d'), {
                    type: 'line',
                    data: {
                        labels: dd.labels,
                        datasets: [{
                            label: 'Hadir',
                            borderColor: '#f48fb1',
                            backgroundColor: 'rgba(244,143,177,0.12)',
                            data: dd.hadir,
                            fill: true
                        }, {
                            label: 'Tidak',
                            backgroundColor: 'rgba(248,187,208,0.08)',
                            data: dd.tidak,
                            fill: true
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false
                    }
                });
            }
            loadTeacherCharts();
        </script>
    </main>
</body>

</html>